#!/bin/bash

REDISPATH=/home/chen/redis
REDISBIN=$REDISPATH/bin
TEMPLEATEPATH=$REDISPATH/cluster_templeate

startserver()
{

	echo "Starting..................."

	cd $TEMPLEATEPATH/7000
	nohup /$REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7000 \033[1;40;32mok\033[0m"
	sleep 0.5

	cd $TEMPLEATEPATH/7001
	nohup $REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7001 \033[1;40;32mok\033[0m"
	sleep 0.5

	cd $TEMPLEATEPATH/7002
	nohup $REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7002 \033[1;40;32mok\033[0m"
	sleep 0.5

	cd $TEMPLEATEPATH/7003
	nohup $REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7003 \033[1;40;32mok\033[0m"
	sleep 0.5

	cd $TEMPLEATEPATH/7004
	nohup $REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7004 \033[1;40;32mok\033[0m"
	sleep 0.5

	cd $TEMPLEATEPATH/7005
	nohup $REDISBIN/redis-server $PWD/redis.conf > /dev/null 2>&1 &
	echo -e "Starting redis server 7005 \033[1;40;32mok\033[0m"
	sleep 0.5

	ps aux |grep "$PWD/.*redis-server" | sed -e "/grep/d"
}

shutdown()
{
	cd $REDISPATH
	$PWD/bin/redis-cli -p 7000 shutdown
	echo -e "shutdown redis server 7000 \033[1;40;32mok\033[0m"
	$PWD/bin/redis-cli -p 7001 shutdown
	echo -e "shutdown redis server 7001 \033[1;40;32mok\033[0m"
	$PWD/bin/redis-cli -p 7002 shutdown
	echo -e "shutdown redis server 7002 \033[1;40;32mok\033[0m"
	$PWD/bin/redis-cli -p 7003 shutdown
	echo -e "shutdown redis server 7003 \033[1;40;32mok\033[0m"
	$PWD/bin/redis-cli -p 7004 shutdown
	echo -e "shutdown redis server 7004 \033[1;40;32mok\033[0m"
	$PWD/bin/redis-cli -p 7005 shutdown
	echo -e "shutdown redis server 7005 \033[1;40;32mok\033[0m"
}

stopserver()
{
	echo "Ending...................."
	SERVERLIST='redis-server'

	for serv in $SERVERLIST
	do
		echo -n "stop $serv "
		ps aux |grep "$PWD/.*server" | sed -e "/grep/d" | grep "$serv" | awk '{print $2}' | xargs kill -9 2&>/dev/null
		while test -f run.sh
		do
			echo -n "."
			count=`ps x |grep "$PWD/.*server" | sed -e '/grep/d' | grep -c "$serv"`
			if [ $count -eq 0 ]; then 
				break
			fi
			sleep 0.5
		done
		echo -e "\033[1;40;32mok\033[0m"
	done 
	echo "running server:"`ps x |grep "server -c"|sed -e '/grep/d'| wc -l`
}

echo "----------------------------start------------------------------------------"

case $1 in 
	stop)
		#stopserver
		shutdown
		;;
	start)
		startserver
		;;
	*)
		#stopserver
		shutdown
		sleep 1
		startserver
		;;
esac

echo "----------------------------end------------------------------------------"

