package main

import (
	"bufio"
	"fmt"
	"os"
	"plugin"
	"strings"
	"plugintest/common"
)

func Add(a, b int) int {
	return a + b
}

func main() {
	common.Common()
	var sum int
	sum = Add(1, 2)
	fmt.Printf("local func a+b=%v \n", sum)
	for {
		fmt.Printf("请输入插件名称:\n")
		reader := bufio.NewReader(os.Stdin)
		text, err := reader.ReadString('\n')
		if err != nil {
			fmt.Println(err)
			return
		}

		text = strings.TrimRightFunc(text, func(c rune) bool {
			//In windows newline is \r\n
			return c == '\r' || c == '\n'
		})

		if text == "end" {
			break
		}
		loadPlugin(text)
	}
}

func loadPlugin(pname string) {
	plug, err := plugin.Open(pname)
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
	addf, err := plug.Lookup("PluginAdd")
	if err != nil {
		fmt.Println(err)
		os.Exit(1)
	}
	sum := addf.(func(a, b int) int)(1, 2)
	fmt.Printf("plugin func a+b=%v \n", sum)
}
